uniform sampler2DRect image;
uniform sampler2D blurImage;
uniform sampler2D vingette;

uniform vec2 bloomFactors;

void main()
{
    
    vec2 texCoords = gl_TexCoord[0].xy;
    vec2 blurCoords = gl_TexCoord[1].xy;
    
    vec4 vignetteColor = texture2D(vingette, blurCoords);
    
    vec4 easedVignetteColor = vignetteColor * 0.6 + vec4(0.4);
    
    vec4 baseColor = texture2DRect(image, texCoords) * easedVignetteColor;
    
    vec4 blurColor = texture2D(blurImage, blurCoords) * easedVignetteColor;
    
    
    float blurBrightness = (blurColor.r + blurColor.g + blurColor.b) * 0.3;
    float difference = (blurBrightness - (baseColor.r + baseColor.g + baseColor.b) * 0.3);
    
    float highlight = (blurBrightness * bloomFactors[1]);
    float amountToAdd = bloomFactors[0] + (highlight * highlight);
    
   // blurColor = mix(baseColor, blurColor,clamp(difference * 1.0, 0.0, 0.5))
    /*if(difference < 0.0)
    {
        blurColor = baseColor;
    }
    else
    {
        blurColor = (blurColor * blurColor);
    }*/
    
    blurColor = mix(baseColor, blurColor, clamp((difference + 0.01) * 50.0, 0.0, 1.0));
    
    vec4 combined = max((baseColor - vec4(0.2)) * 1.0, vec4(0.0)) + blurColor * amountToAdd;
    combined.a = 1.0;

	gl_FragColor = combined * gl_Color;
}
